/*
 * Decompiled with CFR 0.152.
 */
package com.oceancraft.common;

import com.google.common.collect.Maps;
import com.oceancraft.common.EntityAnglerfish;
import com.oceancraft.common.EntityBeachVillager;
import com.oceancraft.common.EntityCrab;
import com.oceancraft.common.EntityFish;
import com.oceancraft.common.EntityKingcrab;
import com.oceancraft.common.EntityLobster;
import com.oceancraft.common.EntityMantaray;
import com.oceancraft.common.EntitySeagull;
import com.oceancraft.common.EntitySeaturtle;
import com.oceancraft.common.EntityShark;
import com.oceancraft.common.EntityStingray;
import com.oceancraft.common.EntityTropicalFish;
import com.oceancraft.common.EntityWhale;
import com.oceancraft.common.Oceancraft;
import com.oceancraft.common.OceancraftConfiguration;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class OceancraftEntities {
    public static final Map<Integer, String> idToModEntityName = Maps.newLinkedHashMap();

    public static void registerMobs() {
        OceancraftEntities.registerOceancraftCreature(EntityFish.class, "OCFish", 40, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityTropicalFish.class, "OCTropicalFish", 41, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityMantaray.class, "OCMantaray", 42, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityStingray.class, "OCStingray", 43, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntitySeaturtle.class, "OCSeaturtle", 44, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityAnglerfish.class, "OCAnglerfish", 45, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityShark.class, "OCShark", 46, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityWhale.class, "OCWhale", 47, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityCrab.class, "OCCrab", 48, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityKingcrab.class, "OCKingcrab", 49, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityLobster.class, "OCLobster", 50, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntitySeagull.class, "OCSeagull", 51, 80, 3, true);
        OceancraftEntities.registerOceancraftCreature(EntityBeachVillager.class, "OCBeachVillager", 52, 80, 3, true);
        OceancraftEntities.spawnCreatures();
    }

    public static void spawnCreatures() {
        if (OceancraftConfiguration.spawnFish) {
            EntityRegistry.addSpawn(EntityFish.class, (int)50, (int)8, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76781_i});
            EntityRegistry.addSpawn(EntityFish.class, (int)50, (int)8, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityFish.class, (int)50, (int)8, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
            EntityRegistry.addSpawn(EntityFish.class, (int)50, (int)8, (int)10, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
        }
        if (OceancraftConfiguration.spawnTropicalFish) {
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)50, (int)6, (int)8, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)50, (int)6, (int)8, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityTropicalFish.class, (int)50, (int)6, (int)8, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnMantaray) {
            EntityRegistry.addSpawn(EntityMantaray.class, (int)15, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76781_i});
            EntityRegistry.addSpawn(EntityMantaray.class, (int)15, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntityMantaray.class, (int)15, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityMantaray.class, (int)15, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnSeaturtle) {
            EntityRegistry.addSpawn(EntitySeaturtle.class, (int)15, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntitySeaturtle.class, (int)15, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntitySeaturtle.class, (int)15, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnStingray) {
            EntityRegistry.addSpawn(EntityStingray.class, (int)15, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntityStingray.class, (int)15, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityStingray.class, (int)15, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnAnglerfish) {
            EntityRegistry.addSpawn(EntityAnglerfish.class, (int)10, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnShark) {
            EntityRegistry.addSpawn(EntityShark.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntityShark.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityShark.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnWhale) {
            EntityRegistry.addSpawn(EntityWhale.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntityWhale.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntityWhale.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
        }
        if (OceancraftConfiguration.spawnSeagull) {
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76772_c});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76767_f});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76785_t});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150583_P});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150582_Q});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150577_O});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150584_S});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150579_T});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150575_M});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76770_e});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76783_v});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150580_W});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76776_l});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76777_m});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76775_o});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76774_n});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76782_w});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150574_L});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150574_L});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76792_x});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150578_U});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150581_V});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76789_p});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76788_q});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_150576_N});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76780_h});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76768_g});
            EntityRegistry.addSpawn(EntitySeagull.class, (int)50, (int)3, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76784_u});
        }
        if (OceancraftConfiguration.spawnCrab) {
            EntityRegistry.addSpawn(EntityCrab.class, (int)16, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
        }
        if (OceancraftConfiguration.spawnKingCrab) {
            EntityRegistry.addSpawn(EntityKingcrab.class, (int)16, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
        }
        if (OceancraftConfiguration.spawnLobster) {
            EntityRegistry.addSpawn(EntityLobster.class, (int)16, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76787_r});
        }
        EntitySpawnPlacementRegistry.setPlacementType(EntityFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityTropicalFish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMantaray.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntitySeaturtle.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityStingray.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAnglerfish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityShark.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityWhale.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntitySeagull.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityCrab.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityKingcrab.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityLobster.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
    }

    public static void registerOceancraftCreature(Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)Oceancraft.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToModEntityName.put(id, entityName);
    }

    public static Entity createEntityByID(int modEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)Oceancraft.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, modEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            Oceancraft.logger.warn("Skipping Oceancraft Entity with id " + modEntityId);
        }
        return entity;
    }
}

