/*
 * Decompiled with CFR 0.152.
 */
package com.oceancraft.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceancraft.common.EntityBeachVillager;
import com.oceancraft.common.Oceancraft;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class BeachVillagerRegistry {
    private static final BeachVillagerRegistry INSTANCE = new BeachVillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, ResourceLocation> newVillagers;
    private boolean hasInit = false;
    private List<BeachVillagerProfession> professions = Lists.newArrayList();

    private BeachVillagerRegistry() {
        this.init();
    }

    public static BeachVillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe((String)"Attempt to register duplicate villager id %d", (Object[])new Object[]{id});
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerVillagerSkin(int villagerId, ResourceLocation villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getVillagerSkin(int villagerType, ResourceLocation defaultSkin) {
        if (BeachVillagerRegistry.instance().newVillagers != null && BeachVillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return BeachVillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(BeachVillagerRegistry.instance().newVillagerIds);
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : BeachVillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        return BeachVillagerRegistry.instance().villageCreationHandlers.get(villagePiece.field_75090_a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public void register(BeachVillagerProfession prof) {
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        BeachVillagerProfession prof = new BeachVillagerProfession("minecraft:fisher0", "oceancraft:textures/entity/beachvillager/fisherman.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "fisher0").init(VanillaTrades.trades[0][0]);
        prof = new BeachVillagerProfession("minecraft:fisher1", "oceancraft:textures/entity/beachvillager/fisherman.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "fisher1").init(VanillaTrades.trades[1][0]);
        prof = new BeachVillagerProfession("minecraft:fisher2", "oceancraft:textures/entity/beachvillager/fisherman.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "fisher2").init(VanillaTrades.trades[2][0]);
        prof = new BeachVillagerProfession("minecraft:fisher3", "oceancraft:textures/entity/beachvillager/fisherman.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "fisher3").init(VanillaTrades.trades[3][0]);
        prof = new BeachVillagerProfession("minecraft:hunter0", "oceancraft:textures/entity/beachvillager/hunter.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "hunter0").init(VanillaTrades.trades[4][0]);
        prof = new BeachVillagerProfession("minecraft:hunter1", "oceancraft:textures/entity/beachvillager/hunter.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "hunter1").init(VanillaTrades.trades[5][0]);
        prof = new BeachVillagerProfession("minecraft:hunter2", "oceancraft:textures/entity/beachvillager/hunter.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "hunter2").init(VanillaTrades.trades[6][0]);
        prof = new BeachVillagerProfession("minecraft:hunter3", "oceancraft:textures/entity/beachvillager/hunter.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "hunter3").init(VanillaTrades.trades[7][0]);
        prof = new BeachVillagerProfession("minecraft:farmer0", "oceancraft:textures/entity/beachvillager/farmer.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "farmer0").init(VanillaTrades.trades[8][0]);
        prof = new BeachVillagerProfession("minecraft:farmer1", "oceancraft:textures/entity/beachvillager/farmer.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "farmer1").init(VanillaTrades.trades[9][0]);
        prof = new BeachVillagerProfession("minecraft:farmer2", "oceancraft:textures/entity/beachvillager/farmer.png");
        this.register(prof);
        new BeachVillagerCareer(prof, "farmer2").init(VanillaTrades.trades[10][0]);
    }

    public static void setRandomProfession(EntityBeachVillager entity, Random rand) {
        entity.setProfession(rand.nextInt(11));
    }

    private static class VanillaTrades {
        private static final EntityBeachVillager.ITradeList[][][][] trades = new EntityBeachVillager.ITradeList[][][][]{{{{new EntityBeachVillager.SellItem(Oceancraft.ItemFishingNet, new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.SellItem(Oceancraft.ItemManta1, new EntityBeachVillager.PriceInfo(1, 1))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemWhale1, new EntityBeachVillager.PriceInfo(2, 2)), new EntityBeachVillager.SellItem(Oceancraft.ItemBigFishingNet, new EntityBeachVillager.PriceInfo(10, 10))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemFish1, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish2, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish3, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish4, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish5, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish6, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemFish7, new EntityBeachVillager.PriceInfo(1, 1))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemTurtle3, new EntityBeachVillager.PriceInfo(2, 2)), new EntityBeachVillager.SellItem(Oceancraft.ItemSnorkel, new EntityBeachVillager.PriceInfo(16, 16)), new EntityBeachVillager.SellItem(Oceancraft.ItemFlippers, new EntityBeachVillager.PriceInfo(18, 18))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemCoralSword, new EntityBeachVillager.PriceInfo(4, 4)), new EntityBeachVillager.SellItem(Oceancraft.ItemTurtleShell, new EntityBeachVillager.PriceInfo(3, 3)), new EntityBeachVillager.SellItem(Oceancraft.ItemCrabClaw, new EntityBeachVillager.PriceInfo(3, 3))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemPoisonSword, new EntityBeachVillager.PriceInfo(10, 10)), new EntityBeachVillager.SellItem(Oceancraft.ItemStingrayTail, new EntityBeachVillager.PriceInfo(1, 1)), new EntityBeachVillager.SellItem(Oceancraft.ItemSharkTooth, new EntityBeachVillager.PriceInfo(1, 1))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemAngler1, new EntityBeachVillager.PriceInfo(2, 2)), new EntityBeachVillager.SellItem(Oceancraft.ItemGlowingDust, new EntityBeachVillager.PriceInfo(3, 3))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemCoralHelmet, new EntityBeachVillager.PriceInfo(8, 8)), new EntityBeachVillager.SellItem(Oceancraft.ItemCoralChestplate, new EntityBeachVillager.PriceInfo(14, 14)), new EntityBeachVillager.SellItem(Oceancraft.ItemCoralPants, new EntityBeachVillager.PriceInfo(12, 12)), new EntityBeachVillager.SellItem(Oceancraft.ItemCoralBoots, new EntityBeachVillager.PriceInfo(6, 6))}}}, {{{new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockCropSeaweed), new EntityBeachVillager.PriceInfo(9, 9)), new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockOysterSeeds), new EntityBeachVillager.PriceInfo(6, 6))}}}, {{{new EntityBeachVillager.SellItem(Oceancraft.ItemBlackPearl, new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.SellItem(Oceancraft.ItemWaterPearl, new EntityBeachVillager.PriceInfo(2, 2))}}}, {{{new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockBrainCoral), new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockSeaRodCoral), new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockSeaWhipCoral), new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockSheetCoral), new EntityBeachVillager.PriceInfo(5, 5)), new EntityBeachVillager.BuyItem(Item.func_150898_a((Block)Oceancraft.BlockStarCoral), new EntityBeachVillager.PriceInfo(5, 5))}}}};

        private VanillaTrades() {
        }
    }

    public static class BeachVillagerCareer {
        private BeachVillagerProfession profession;
        private String name;
        private int id;

        public BeachVillagerCareer(BeachVillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        private BeachVillagerCareer init(EntityBeachVillager.ITradeList[][] traids) {
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BeachVillagerCareer)) {
                return false;
            }
            BeachVillagerCareer oc = (BeachVillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    public static class BeachVillagerProfession {
        private ResourceLocation name;
        private ResourceLocation texture;
        private List<BeachVillagerCareer> careers = Lists.newArrayList();

        public BeachVillagerProfession(String name, String texture) {
            this.name = new ResourceLocation(name);
            this.texture = new ResourceLocation(texture);
        }

        private void register(BeachVillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }
    }

    public static interface IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(StructureVillagePieces.PieceWeight var1, StructureVillagePieces.Start var2, List var3, Random var4, int var5, int var6, int var7, EnumFacing var8, int var9);
    }
}

