/*
 * Decompiled with CFR 0.152.
 */
package nu.com.davidt.BetterBan;

import nu.com.davidt.BetterBan.BetterBan;
import nu.com.davidt.BetterBan.Util;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;

public class PlayerListener
implements Listener {
    private final transient BetterBan plugin;

    public PlayerListener(BetterBan parent) {
        this.plugin = parent;
    }

    @EventHandler
    public void PlayerLoginEvent(PlayerLoginEvent event) {
        String message;
        Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("maintenanceEnabled")) {
            Boolean bypassMaintCheck = false;
            if (this.plugin.getConfig().getBoolean("maintenanceWhitelistBypass") && player.isWhitelisted()) {
                bypassMaintCheck = true;
            }
            if (!(bypassMaintCheck.booleanValue() || player.hasPermission("betterban.maintenance.allow") && player.isOp())) {
                String message2 = this.plugin.getConfig().getString("maintenanceMessage");
                message2 = Util.formatChatColours(message2);
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, message2);
                return;
            }
        }
        if (this.plugin.getServer().hasWhitelist() && !player.isWhitelisted()) {
            message = this.plugin.getConfig().getString("whitelistMessage");
            message = Util.formatChatColours(message);
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, message);
            return;
        }
        if (player.isBanned()) {
            message = this.plugin.getConfig().getString("bannedMessage");
            message = Util.formatChatColours(message);
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, message);
            return;
        }
        event.allow();
    }

    @EventHandler
    public void PlayerJoinEvent(PlayerJoinEvent event) {
        if (!this.plugin.getConfig().getBoolean("showLoginQuitMessages")) {
            event.setJoinMessage(null);
            return;
        }
        if (this.plugin.getConfig().getBoolean("customLoginQuitMessages")) {
            String message = this.plugin.getConfig().getString("loginMessage");
            message = message.replaceAll("%p", event.getPlayer().getDisplayName());
            message = Util.formatChatColours(message);
            event.setJoinMessage(message);
        }
    }

    @EventHandler
    public void PlayerQuitEvent(PlayerQuitEvent event) {
        if (!this.plugin.getConfig().getBoolean("showLoginQuitMessages")) {
            event.setQuitMessage(null);
            return;
        }
        if (this.plugin.getConfig().getBoolean("customLoginQuitMessages")) {
            String message = this.plugin.getConfig().getString("quitMessage");
            message = message.replaceAll("%p", event.getPlayer().getDisplayName());
            message = Util.formatChatColours(message);
            event.setQuitMessage(message);
        }
    }

    @EventHandler
    public void PlayerKickEvent(PlayerKickEvent event) {
        event.setLeaveMessage(null);
    }

    @EventHandler
    public void ServerListPingEvent(ServerListPingEvent event) {
        if (this.plugin.getConfig().getBoolean("maintenanceEnabled")) {
            String message = this.plugin.getConfig().getString("maintenanceMOTD");
            message = Util.formatChatColours(message);
            event.setMotd(message);
        }
    }
}

